/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.dialog.comp.VMConfigurePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockVMMappingInfo;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;

public class VMMappingPagerPrinter
extends LogoPrintable
implements Printable {
    protected int fCurrentIndex = 0;
    private final int lineDiff = 15;
    private Vector<Integer> fIndexArr;
    private int fPages = -1;
    private Vector<BlockVMMappingInfo.Param2VMInfo> fDataVector;
    int[] ColumnLen = new int[]{20, 310, 220, 50, 70};

    public VMMappingPagerPrinter(LogoDrawing logoDrawing) {
        super(logoDrawing);
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillVMMappingArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if ((pi -= this.fFirstPageNumber) >= this.fPages) {
            return 1;
        }
        this.fCurrentIndex = this.fIndexArr.get(pi);
        g.setColor(Color.black);
        this.translate(g, pf, true);
        Dimension printArea = this.printFooter(g, pf, pi + this.fFirstPageNumber + 1, this.getTotalPage());
        Rectangle preClip = g.getClipBounds();
        Rectangle curClip = new Rectangle(1, 1, printArea.width, printArea.height);
        Rectangle newClip = preClip.intersection(curClip);
        if (!newClip.isEmpty()) {
            this.setClip(g, newClip, pf, false);
            this.printVMMaping(g, pf);
            this.setClip(g, preClip, pf, false);
        }
        return 0;
    }

    public void fillVMMappingArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fPages = 0;
        this.fCurrentIndex = 0;
        this.fillVMMapingConn();
        while (this.fCurrentIndex < this.fDataVector.size()) {
            this.fIndexArr.add(this.fPages, this.fCurrentIndex);
            this.printVMMaping(g, pf);
            ++this.fPages;
        }
    }

    protected void fillVMMapingConn() {
        BlockVMMappingInfo vmMapping = this.fDrawing.getWiringDiagram().getBlockVMMappingInfo();
        this.fDataVector = vmMapping.getMappingInfo();
        this.fIndexArr = new Vector();
    }

    protected void printVMMaping(Graphics g, PageFormat pf) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        this.printVMMappingInfo(g, printArea);
    }

    protected void printVMMappingInfo(Graphics pg, Dimension usableDimension) {
        int xPosBlock = 20;
        int yPos = 0;
        Font ft = new Font("Dialog", 1, 12);
        pg.setFont(ft);
        FontMetrics metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        pg.drawString(Language.getString("tool.vmConfigure.mapping"), xPosBlock, yPos += 23);
        yPos += textHeight + 3;
        ft = new Font("Dialog", 0, 12);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        Object[] title = this.initializeColumn();
        yPos = this.generateRow(pg, title, xPosBlock, yPos);
        while (this.fDataVector.size() > this.fCurrentIndex && yPos + textHeight + 15 <= usableDimension.height) {
            BlockVMMappingInfo.Param2VMInfo p = this.fDataVector.elementAt(this.fCurrentIndex);
            ParameterItem parameterItem = p.paramItem;
            String text = "";
            Block block = parameterItem.getParameter().getBlock();
            if (block != null) {
                text = block.getLocalizedName(true);
            }
            Object[] item = new Object[]{String.valueOf(this.fCurrentIndex + 1), text, parameterItem.toString(), VMConfigurePanel.getVMTypeName(p.length), String.valueOf(p.address)};
            yPos = this.generateRow(pg, item, xPosBlock, yPos);
            ++this.fCurrentIndex;
        }
    }

    private Object[] initializeColumn() {
        String titleId = Language.getString("panel.tablePanel.ID");
        String titleBlock = Language.getString("dialog.parameter.message.blockBorder", "Block");
        String titleParameter = Language.getString("dialog.parameter.message.blockParameterBorder", "Parameter");
        String titleType = Language.getString("tool.vmConfigure.vmType", "VM Type");
        String titleAddress = Language.getString("tool.vmConfigure.address", "Address");
        Object[] title = new Object[]{titleId, titleBlock, titleParameter, titleType, titleAddress};
        return title;
    }

    private int generateRow(Graphics fpg, Object[] row, int xPosBlock, int yPos) {
        int currenttextX = xPosBlock;
        int cellHeight = 25;
        int cellTextX = 15;
        int cellTextY = 18;
        fpg.drawLine(xPosBlock, yPos, xPosBlock, yPos + cellHeight);
        currenttextX = xPosBlock + cellTextX;
        fpg.drawString((String)row[0], currenttextX, yPos + cellTextY);
        fpg.drawLine(currenttextX += this.ColumnLen[0], yPos, currenttextX, yPos + cellHeight);
        fpg.drawString((String)row[1], currenttextX += cellTextX, yPos + cellTextY);
        fpg.drawLine(currenttextX += this.ColumnLen[1], yPos, currenttextX, yPos + cellHeight);
        fpg.drawString((String)row[2], currenttextX += cellTextX, yPos + cellTextY);
        fpg.drawLine(currenttextX += this.ColumnLen[2], yPos, currenttextX, yPos + cellHeight);
        fpg.drawString((String)row[3], currenttextX += cellTextX, yPos + cellTextY);
        fpg.drawLine(currenttextX += this.ColumnLen[3], yPos, currenttextX, yPos + cellHeight);
        fpg.drawString((String)row[4], currenttextX += cellTextX, yPos + cellTextY);
        fpg.drawLine(currenttextX += this.ColumnLen[4], yPos, currenttextX, yPos + cellHeight);
        fpg.drawLine(xPosBlock, yPos, currenttextX, yPos);
        fpg.drawLine(xPosBlock, yPos += cellHeight, currenttextX, yPos);
        return yPos;
    }
}

